﻿<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_controls_screen.php';

///////////////////////////////////////////////////////////////////////////

class DemoSetupScreen extends AbstractControlsScreen
{
    const ID = 'setup';

    ///////////////////////////////////////////////////////////////////////

    public function __construct()
    {
        parent::__construct(self::ID);
    }
	public static function get_media_url_str()
    {
        return MediaURL::encode(array('screen_id' => self::ID));
    }
    public function do_get_control_defs(&$plugin_cookies)
    {
        $defs = array();
		global $need_reset;
		
		

		$customer_id = isset($plugin_cookies->customer_id) ?
            $plugin_cookies->customer_id : '';
		if ($customer_id=='') { $customer_id = "No data"; } // if no data about custumer in cookies
		
		 $customer_domain = isset($plugin_cookies->customer_domain) ?
            $plugin_cookies->customer_domain : '';
		$customer_pin = isset($plugin_cookies->customer_pin) ?
            $plugin_cookies->customer_pin : '';
		
		$quality = isset($plugin_cookies->quality) ?
            $plugin_cookies->quality : 'dune';
		
		$quality_ops = array();
        $quality_ops['dune'] = 'HLS';
        $quality_ops['dunets'] = 'TS';		
			
			
        $show_tv = isset($plugin_cookies->show_tv) ?
            $plugin_cookies->show_tv : 'yes';
        $show_vod = isset($plugin_cookies->show_vod) ?
            $plugin_cookies->show_vod : 'yes';
        $epg_shift = isset($plugin_cookies->epg_shift) ?
            $plugin_cookies->epg_shift : '0';
        $buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
        
        $show_ops = array();
        $show_ops['yes'] = 'Yes';
        $show_ops['no'] = 'No';

        for ($i = -12; $i<13; $i++)
		    $shift_ops[$i*3600] = $i;
		
		$this->add_combobox($defs,
            'quality', 'TV Stream:',
            $quality, $quality_ops, 0, true);
			
			ControlFactory::add_vgap($defs, -8);
			
			if ($need_reset == 1) {
				$this->add_button($defs,
		    	'reboot', null,
          	    'SAVE', 200);
			}
                             

        $this->add_combobox($defs,
            'epg_shift', 'EPG correction (hour):',
            $epg_shift, $shift_ops, 0, true);


            $show_buf_time_ops = array();

            $show_buf_time_ops[0] = 'Default';
            $show_buf_time_ops[500] = '0.5 s';
            $show_buf_time_ops[1000] = '1 s';
            $show_buf_time_ops[2000] = '2 s';
            $show_buf_time_ops[3000] = '3 s';
            $show_buf_time_ops[5000] = '5 s';
            $show_buf_time_ops[10000] = '10 s';

            $this->add_combobox
            (
                $defs,
                'buf_time',
                'Buferisation time:',
                $buf_time, $show_buf_time_ops, 0, true
            );
			
			
			
			$this->add_vgap($defs, 36);
			
		
        	$this->add_label($defs, 'Domain:', $customer_domain);
			
			$this->add_label($defs, 'ID:', $customer_id);
			
			ControlFactory::add_vgap($defs, -8);
		
			$this->add_button($defs,
		    	'edit_login_data', null,
          	    'Change login data', 200);
				
			$this->add_button($defs,
		    	'reboot', null,
          	    'Reboot', 200);
				
			$this->add_vgap($defs, 36);
			
			$this->add_label($defs, 'Version:', DemoConfig::PLUGIN_VERSION);
			 
			if ($customer_id=="No data") {
				$statistika = "Enter customer data";
			} 
			else {
				$statistika = file_get_contents('http://'.$customer_domain.'/api/'.$customer_pin.'//stat');
				$obj = json_decode($statistika, true); 
				$statistika = date("Y.m.d H:i:s", $obj[0]['pkTimeTill']); // 12345
			}
			
						
			$this->add_label($defs, 'Subscription ends:', $statistika);
		
        return $defs;
    }

    public function get_control_defs(MediaURL $media_url, &$plugin_cookies)
    {
        return $this->do_get_control_defs($plugin_cookies);
    }
	
	public function do_get_edit_subscription_defs(
        &$plugin_cookies)
    {
        $defs = array();
		$add_params = null;
		
        $customer_domain = isset($plugin_cookies->customer_domain) ?
            $plugin_cookies->customer_domain : '';
		$customer_id = isset($plugin_cookies->customer_id) ?
            $plugin_cookies->customer_id : '';
		$customer_pin = isset($plugin_cookies->customer_pin) ?
            $plugin_cookies->customer_pin : '';
        ControlFactory::add_vgap($defs, 15);
		
		ControlFactory::add_text_field($defs,
			$this, $add_params,						   
            'customer_domain', 'Domain:',
			$customer_domain, false, false, false, false, 525);
			
		ControlFactory::add_text_field($defs,
			$this, $add_params,						   
            'customer_id', 'ID:',
			$customer_id, true, false, false, false, 525);
			
		ControlFactory::add_text_field($defs,
			$this, $add_params,						   
            'customer_pin', 'Pin:',
			$customer_pin, true, true, false, false, 525);
			

        ControlFactory::add_vgap($defs, 35);

        ControlFactory::add_button($defs,
            $this, $add_params,
            'apply_login_data', null, 'Save', 300);

        ControlFactory::add_vgap($defs, -4);

        ControlFactory::add_close_dialog_button($defs,
            'Cancel', 300);
		
        return $defs;
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
		global $need_reset;
		$need_close_dialog = false;
        $need_reset_controls = false;
		
		
        if ($user_input->action_type === 'apply') {
            if ($user_input->control_id === 'edit_login_data')
            {
				return ActionFactory::show_dialog(
				'Authorization data',
				$this->do_get_edit_subscription_defs(
                $plugin_cookies),
				true);
            }
			elseif ($user_input->control_id === 'reboot')
            {
				$need_reset = 0;
				shell_exec('reboot');
            }
			elseif ($user_input->control_id === 'apply_login_data') {
				if ($user_input->customer_id === '')
                {
                    return ActionFactory::show_error(false,
                        'Data entry error',
                        array('Entry "ID" cannot be empty'));
                }
				elseif ($user_input->customer_domain === '') {
					return ActionFactory::show_error(false,
                        'Data entry error',
                        array('Entry "Domain" cannot be emptry'));
				}
				elseif ($user_input->customer_pin === '') {
					return ActionFactory::show_error(false,
                        'Data entry error',
                        array('Entry "Pin" cannot be emptry'));
				}
				else {
						hd_print("Login: changing customer_id value to ".$user_input->customer_id);
						$plugin_cookies->customer_id = $user_input->customer_id;
						$plugin_cookies->customer_domain = $user_input->customer_domain;
						$plugin_cookies->customer_pin = $user_input->customer_pin;
						//$plugin_cookies->customer_stream = $user_input->customer_stream;
						
						$TOKEN_URL = DemoConfig::USER_TOKEN_URL;
						
						$TOKEN_URL = str_replace("USER-ID", $user_input->customer_id, $TOKEN_URL);
						$TOKEN_URL = str_replace("USER-PIN", $user_input->customer_pin, $TOKEN_URL);
						$TOKEN_URL = str_replace("USER-DOMAIN", $user_input->customer_domain, $TOKEN_URL);
						
						hd_print("Link 23: ".$TOKEN_URL);
						
						$html = file_get_contents($TOKEN_URL);
						$obj = json_decode($html, true);
						if (isset($obj['token'])) $TOKEN_URL = $obj['token'];
						$plugin_cookies->customer_token = isset($TOKEN_URL) ? $TOKEN_URL : '';
						$need_close_dialog = true;
                		$need_reset_controls = true;
					
				}
			}
		}
		elseif ($user_input->action_type === 'confirm')
        {
            $control_id = $user_input->control_id;
            $new_value = $user_input->{$control_id};
            hd_print("Setup: changing $control_id value to $new_value");

            if ($control_id === 'show_tv')
                $plugin_cookies->show_tv = $new_value;
            else if ($control_id === 'show_vod')
                $plugin_cookies->show_vod = $new_value;
            else if ($control_id === 'buf_time')
                $plugin_cookies->buf_time = $new_value;
            else if ($control_id === 'epg_shift')
                $plugin_cookies->epg_shift = $new_value;
			else if ($control_id === 'quality'){
				$plugin_cookies->quality= $new_value;
				$need_reset = 1;
				/*ActionFactory::show_error(true, // This string without return wont work
                        'Changing quality',
                        array('Player will restart now'));
				sleep(5);
				shell_exec('reboot');*/

			}
				
			$need_reset_controls = true;
        }
		
		if ($need_reset_controls) {
            $defs = $this->do_get_control_defs($plugin_cookies);

            $reset_controls_action = ActionFactory::reset_controls(
                $defs);

            if ($need_close_dialog) {
                return ActionFactory::close_dialog_and_run(
                    $reset_controls_action);
            }

            return $reset_controls_action;
        }

        return null;

    }
}

///////////////////////////////////////////////////////////////////////////
?>
