﻿<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/hashed_array.php';
require_once 'lib/tv/abstract_tv.php';
require_once 'lib/tv/default_epg_item.php';

require_once 'starnet_channel.php';
require_once 'starnet_config.php';

///////////////////////////////////////////////////////////////////////////

class DemoTv extends AbstractTv
{
    public function __construct()
    {
        parent::__construct(
            AbstractTv::MODE_CHANNELS_N_TO_M,
            DemoConfig::TV_FAVORITES_SUPPORTED,
            true);
    }

    public function get_fav_icon_url()
    {
        return DemoConfig::FAV_CHANNEL_GROUP_ICON_PATH;
    }

    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////

    protected function load_channels(&$plugin_cookies)
    {
		
		$USER_TOKEN = isset($plugin_cookies->customer_token) ? $plugin_cookies->customer_token : '';
		$USER_DOMAIN = isset($plugin_cookies->customer_domain) ? $plugin_cookies->customer_domain : '';
		
		$QUALITY = isset($plugin_cookies->quality) ? $plugin_cookies->quality : 'dune';

		$link = DemoConfig::CHANNEL_LIST_URL;
		$link = str_replace("USER-TOKEN", $USER_TOKEN, $link);
		$link = str_replace("USER-DOMAIN", $USER_DOMAIN, $link);
		$link = str_replace("USER-QUALITY", $QUALITY, $link);
		// ------------- END Replace procedure ----------------
		hd_print("LINK FINAL: " . $link);
		
		if ($link == DemoConfig::CHANNEL_LIST_URL)
			throw new Exception('Can not fetch parametrs');
		
        $doc = file_get_contents($link, true);
     
        if (is_null($doc))
            throw new Exception('Can not fetch playlist');
     
        $xml = simplexml_load_string($doc);

        if ($xml === false)
        {
            hd_print("Error: can not parse XML document.");
            hd_print("XML-text: $doc.");
            throw new Exception('Illegal XML document');
        }

        if ($xml->getName() !== 'tv_info')
        {
            hd_print("Error: unexpected node '" . $xml->getName() . "'. Expected: 'tv_info'");
            throw new Exception('Invalid XML document');
        }

        $this->channels = new HashedArray();
        $this->groups = new HashedArray();

        if ($this->is_favorites_supported())
        {
            $this->groups->put(
                new FavoritesGroup(
                    $this,
                    '__favorites',
                    DemoConfig::FAV_CHANNEL_GROUP_CAPTION,
                    DemoConfig::FAV_CHANNEL_GROUP_ICON_PATH));
        }

        $this->groups->put(
            new AllChannelsGroup(
                $this,
                DemoConfig::ALL_CHANNEL_GROUP_CAPTION,
                DemoConfig::ALL_CHANNEL_GROUP_ICON_PATH));


        foreach ($xml->tv_categories->children() as $xml_tv_category)
        {
            if ($xml_tv_category->getName() !== 'tv_category')
            {
                hd_print("Error: unexpected node '" . $xml_tv_category->getName() .
                    "'. Expected: 'tv_category'");
                throw new Exception('Invalid XML document');
            }

            $this->groups->put(
                new DefaultGroup(
                    strval($xml_tv_category->id),
                    strval($xml_tv_category->caption),
                    strval($xml_tv_category->icon_url)));
        }
        $i = 0;
        $gid = 0;
        foreach ($xml->tv_channels->children() as $xml_tv_channel)
        {
            if ($xml_tv_channel->getName() !== 'tv_channel')
            {
                hd_print("Error: unexpected node '" . $xml_tv_channel->getName() .
                    "'. Expected: 'tv_channel'");
                throw new Exception('Invalid XML document');
            }
            $id = (strval($xml_tv_channel->id) != NULL ) ? strval($xml_tv_channel->id) : 1000 + $i;
	    $cid = $gid."_".$id;
	    $i++;
	    $buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0; //буферизация	 

	    $have_archive=false;
	    $have_archive_time=intval($xml_tv_channel->archive_time);
	    if (intval($have_archive_time) > 0) $have_archive=true;
	    $timeshift_hours = 0;
            $channel =
                new DemoChannel(
                    strval($cid),
                    strval($xml_tv_channel->caption),
                    strval($xml_tv_channel->icon_url),
                    $have_archive,
                    $have_archive_time,
                    strval($xml_tv_channel->streaming_url),
                    intval($xml_tv_channel->number),
                    intval($xml_tv_channel->num_past_epg_days),
                    intval($xml_tv_channel->num_future_epg_days),
                    intval($xml_tv_channel->protected),
                    $timeshift_hours,$buf_time);   

            $this->channels->put($channel);

            foreach ($xml_tv_channel->tv_categories->children() as $xml_tv_cat_id)
            {
                if ($xml_tv_cat_id->getName() !== 'tv_category_id')
                {
                    hd_print("Error: unexpected node '" . $xml_tv_cat_id->getName() .
                        "'. Expected: 'tv_category_id'");
                    throw new Exception('Invalid XML document');
                }

                $tv_category_id = intval($xml_tv_cat_id);

                $group = $this->groups->get($tv_category_id);


                $channel->add_group($group);
                $group->add_channel($channel);
            }
        }
    }
    
    
     public function get_tv_playback_url($channel_id, $archive_ts, $protect_code, &$plugin_cookies)
    {
        $url = $this->get_channel($channel_id)->get_streaming_url();  
        if (intval($archive_ts) > 0)
            $url .= "?archive=$archive_ts";
          
        $nado = $this->get_channel($channel_id)->is_protected();
        if ($nado) 
        {
       	   if ($protect_code !=='5643')  $url='';  //Children protection code = 5643
        }
        return $url;
    }

    ///////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////


    public function get_day_epg_iterator($channel_id, $day_start_ts, &$plugin_cookies)
    { 
    list($garb, $channel_id) = preg_split('/_/', $channel_id);
    $epg_shift = isset($plugin_cookies->epg_shift) ? $plugin_cookies->epg_shift : '0';

    $epg_date = date("Y-m-d", $day_start_ts);
    $epg = array();

    if (file_exists("/tmp/channel_".$channel_id."_".$epg_date) && filesize("/tmp/channel_".$channel_id."_".$epg_date) > 7000) {
	$doc = file_get_contents("/tmp/channel_".$channel_id."_".$epg_date);
	$epg = unserialize($doc);
    }
    else {
    try {
        $doc = file_get_contents(sprintf(DemoConfig::EPG_URL_FORMAT, $channel_id, $epg_date ));
    }
    catch (Exception $e) {
        hd_print("Can't fetch EPG ID:$id DATE:$epg_date");
        return array();
    }
    $epg=json_decode($doc,true);
     if(is_array($epg)){
     file_put_contents("/tmp/channel_".$channel_id."_".$epg_date, serialize($epg));
     }
    }
    $epg_result = array();
    ksort($epg, SORT_NUMERIC);
    foreach ($epg as $item => $value) {
    $descript=isset($value["desc"]) ? strval($value["desc"]) : "";
        $epg_result[] =
                new DefaultEpgItem(
                    strval($value["epg"]),
                    $descript,
                    intval($value["start"] + $epg_shift),
                    intval(-1));
    }
    return
            new EpgIterator(
                $epg_result,
                $day_start_ts,
                $day_start_ts + 100400);
    }
}



?>
