<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/user_input_handler_registry.php';

class DemoEntryHandler
    implements UserInputHandler
{

    public function __construct()
    {
        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_handler_id()
    {
        return 'entry';
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        //foreach ($user_input as $key => $value)
        //   hd_print("$key => $value");

		if (isset($user_input->entry_id)) {
			if ($user_input->entry_id === 'setup') {
				return ActionFactory::open_folder();
			}
			elseif ($user_input->entry_id === 'tv') {
				$customer_id = isset($plugin_cookies->customer_id) ? $plugin_cookies->customer_id : '';
				
				if ($customer_id=='') {
					return ActionFactory::show_dialog(
					'Authorization data',
					DemoSetupScreen::do_get_edit_subscription_defs(
					$plugin_cookies),
					true);
				} 
				else {
					return ActionFactory::open_folder();
				}
			}
		}
		if (isset($user_input->control_id) && isset($user_input->handler_id)) {	// data from open dialog
			if ($user_input->control_id === 'apply_login_data' && $user_input->handler_id === 'entry') {
				if ($user_input->customer_id === '') {
						return ActionFactory::show_error(false,
							'Data entry error',
							array('Entry "ID" cannot be empty'));
							
					}
					elseif ($user_input->customer_pin === '') {
						return ActionFactory::show_error(false,
							'Date Entry error',
							array('Entry "Pin" cannot be empty'));
					}
					elseif ($user_input->customer_domain === '') {
						return ActionFactory::show_error(false,
							'Date Entry error',
							array('Entry "Domain" cannot be empty'));
					}
					else {

							hd_print("Login: changing customer_id value to ".$user_input->customer_id);
							$plugin_cookies->customer_id = $user_input->customer_id;
							$plugin_cookies->customer_domain = $user_input->customer_domain;
							$plugin_cookies->customer_pin = $user_input->customer_pin;
							
							$TOKEN_URL = DemoConfig::USER_TOKEN_URL;
							
							$TOKEN_URL = str_replace("USER-ID", $user_input->customer_id, $TOKEN_URL);
							$TOKEN_URL = str_replace("USER-PIN", $user_input->customer_pin, $TOKEN_URL);
							$TOKEN_URL = str_replace("USER-DOMAIN", $user_input->customer_domain, $TOKEN_URL);
							
							
							$html = file_get_contents($TOKEN_URL);
							$obj = json_decode($html, true);
							if (isset($obj['token'])) $TOKEN_URL = $obj['token'];
							$plugin_cookies->customer_token = isset($TOKEN_URL) ? $TOKEN_URL : '';
							
							return ActionFactory::close_dialog_and_run(ActionFactory::open_folder());
				}
			}
		}

        return null;
    }
}

///////////////////////////////////////////////////////////////////////////
?>
